package com.company.model;

import com.company.exceptions.DuplicatedDataException;
import javafx.util.Pair;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EnrollContainer {
    private List<Enroll> enrolls;
    private Enroll search(int number, String initials) {
        Enroll  enroll;
        Iterator<Enroll> it = this.enrolls.iterator();
        while(it.hasNext()){
            enroll = it.next();
            Subject subject = enroll.getSubject();
            Student student = enroll.getStudent();
            if(subject.isEqualTo(initials) && student.getNumber() == number){
                return enroll;
            }
        }
        return null;
    }
    public EnrollContainer(){
        enrolls = new ArrayList<Enroll>();
    }
    public List<Enroll> getAll(){
        List<Enroll> newlist = new ArrayList();
        newlist.addAll(this.enrolls);
        return newlist;
    }
    public Enroll get(int number,String initials){
        Enroll enroll = search(number,initials);
        return enroll;
    }



   public  List<Pair<Subject, Integer>> getSubjects(int number){
        List<Pair<Subject, Integer> > newlist = new ArrayList<Pair<Subject, Integer>>();
        Enroll  enroll;
        Iterator<Enroll> it = this.enrolls.iterator();
        while(it.hasNext()){
            enroll = it.next();
            Student student = enroll.getStudent();
            if(student.getNumber() == number) {
                Subject subject = enroll.getSubject();
                int grade = enroll.getGrade();
                newlist.add(new Pair<Subject, Integer>(subject, grade));
            }

        }
        return newlist;
    }
    public List<Pair<Student, Integer>> getStudents(String initials){
        List<Pair<Student, Integer> > newlist = new ArrayList<Pair<Student, Integer>>();
        Enroll  enroll;
        Iterator<Enroll> it = this.enrolls.iterator();
        while(it.hasNext()){
            enroll = it.next();
            Subject subject = enroll.getSubject();
            if(subject.isEqualTo(initials)) {
                Student Student = enroll.getStudent();
                int grade = enroll.getGrade();
                newlist.add(new Pair<Student, Integer>(Student, grade));
            }
        }
        return newlist;
    }
    public void add(Enroll obj){
        Subject subject = obj.getSubject();
        Student student = obj.getStudent();
        Enroll enroll = search(student.getNumber(), subject.getInitials());
        if(enroll == null){
            this.enrolls.add(obj);
        }else{
            String msg = "Enroll: " + student.getNumber() +" " + subject.getInitials();
            throw  new DuplicatedDataException(msg);
        }
    }
    public void remove(int number,String initials){
        Enroll enroll = search(number, initials);
        if(enroll != null){
            this.enrolls.remove(enroll);
        }
    }
    public void  update(int number, String initials,int grade){
        Enroll enroll = search(number, initials);
        if(enroll != null){
            enroll.setGrade(grade);
        }
    }

}
